
//=====================================================================================================
//                                      M100 2-wire                                                   
//=====================================================================================================
//! Filename:           C100.DDL
//! Function:           Device Description for M100 2-wire
//! Device:             M100 2-wire DinRail
//! Device Revision:    1
//! DD Revision:        1
//! Last edit:		 
//! Manufacturer:	    Mettler-Toledo AG
//!					    Process Analytics
//!					    Im Hackacker 15
//!				        CH 8092 Urdorf (Switzerland)
//!					    Tel: +41 44 729 62 11
//!					    Fax: +41 44 729 66 36
//!					    Internet: www.mt.com/pro
//!     Copyright:(C) Mettler-Toledo AG, 2008 All Rights Reserved.                                                                              
//                                                                                                     
// $Date: 2014/07/11 01:22:34 $:
// $State: Exp $:
// $Revision: 1.15 $:  
//
//=============================================================================

//=============================================================================
//                          VERSION HISTORY
//=============================================================================
// $Log: C100_DinRail.ddl,v $
// Revision 1.15  2014/07/11 01:22:34  zhang-139
// redefine PDM macro
//
// Revision 1.14  2014/06/12 02:23:29  hu-33
// no message
//
// Revision 1.13  2014/06/06 03:45:38  hu-33
// no message
//
// Revision 1.12  2014/06/04 02:21:28  hu-33
// mbar P not available except O2 sensor
//
// Revision 1.11  2014/05/30 05:50:47  hu-33
// add dinrail pic files
//
// Revision 1.10  2014/05/27 06:35:40  zhang-139
// add comment for host macro
//
// Revision 1.9  2014/05/20 02:58:09  zhang-139
// no message
//
// Revision 1.8  2014/05/05 03:24:07  hu-33
// fix mantis: 0008203
//
// Revision 1.7  2014/04/30 06:33:42  hu-33
// 2014-04-30
//
// Revision 1.6  2014/04/18 07:48:18  hu-33
// no message
//
// Revision 1.5  2014/04/18 07:34:41  hu-33
// no message
//
// Revision 1.4  2014/04/14 02:02:28  hu-33
// no message
//
// Revision 1.3  2014/04/01 06:57:20  hu-33
// 2014-04-01
//
// Revision 1.2  2014/03/17 05:34:07  zhang-139
// 1.add enable_1_2_point macro for M400 2-wire and DIN Rail
//
// Revision 1.1  2014/01/27 03:01:26  hu-33
// *** empty log message ***
//:
//=============================================================================
#define  MT_DEVICE_NAME "M100/2H DR"
#define STR_BUILDINFO   "2014/July/21"

//macro for different hosts
#define _PDM2_SYSTEM_                 //Siemens system
#define _DTM_PDM1_            
//#define _DTM_only 
//#define _PRM_                 //Yokogawa system

#define _ENABLE_1_2_POINT
#define __C100_DINRAIL

#ifdef _DTM_PDM1_
	#define __TOKVER__          800
    #define MT_DEVICE_TYPE      0x8e7f
	MANUFACTURER 0x8e, DEVICE_TYPE 0x8e7f, DEVICE_REVISION 1, DD_REVISION 1             //M100 2-wire DinRail
#else                                                                                       
	#if __TOKVER__ >= 800
    #define MT_DEVICE_TYPE      0x8E7F
	MANUFACTURER METTLER_TOLEDO, DEVICE_TYPE _C100_DINRAIL_EXP, DEVICE_REVISION 1, DD_REVISION 1
	#else
    #define MT_DEVICE_TYPE      0x007f
    MANUFACTURER METTLER_TOLEDO, DEVICE_TYPE _C100_DINRAIL, DEVICE_REVISION 1, DD_REVISION 1
    #endif
#endif

#include "HA_MAIN.dd"
